/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.settings;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Hyperlink;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.config.RuntimeSettings;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.settings.BaseSettingsScene;
import pro.gravit.launcher.gui.scenes.settings.components.LanguageSelectorComponent;
import pro.gravit.launcher.gui.scenes.settings.components.ThemeSelectorComponent;
import pro.gravit.launcher.gui.stage.ConsoleStage;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class GlobalSettingsScene
extends BaseSettingsScene {
    private ThemeSelectorComponent themeSelector;
    private LanguageSelectorComponent languageSelectorComponent;

    public GlobalSettingsScene(JavaFXApplication application) {
        super("scenes/settings/globalsettings.fxml", application);
    }

    @Override
    public String getName() {
        return "globalsettings";
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.themeSelector = new ThemeSelectorComponent(this.application, this.componentList);
        this.languageSelectorComponent = new LanguageSelectorComponent(this.application, this.componentList);
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#console")).setOnAction(e -> {
            try {
                if (this.application.gui.consoleStage == null) {
                    this.application.gui.consoleStage = new ConsoleStage(this.application);
                }
                if (this.application.gui.consoleStage.isNullScene()) {
                    this.application.gui.consoleStage.setScene(this.application.gui.consoleScene, true);
                }
                this.application.gui.consoleStage.show();
            }
            catch (Exception ex) {
                this.errorHandle(ex);
            }
        });
        Hyperlink updateDirLink = (Hyperlink)LookupHelper.lookup((Node)this.componentList, "#folder", "#path");
        String directoryUpdates = DirBridge.dirUpdates.toAbsolutePath().toString();
        updateDirLink.setText(directoryUpdates);
        if (updateDirLink.getTooltip() != null) {
            updateDirLink.getTooltip().setText(directoryUpdates);
        }
        updateDirLink.setOnAction(e -> this.application.openURL(directoryUpdates));
        ((ButtonBase)LookupHelper.lookup((Node)this.componentList, "#changeDir")).setOnAction(e -> {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setTitle(this.application.getTranslation("runtime.scenes.settings.dirTitle"));
            directoryChooser.setInitialDirectory(DirBridge.dir.toFile());
            File choose = directoryChooser.showDialog((Window)this.application.getMainStage().getStage());
            if (choose == null) {
                return;
            }
            Path newDir = choose.toPath().toAbsolutePath();
            try {
                DirBridge.move((Path)newDir);
            }
            catch (IOException ex) {
                this.errorHandle(ex);
            }
            this.application.runtimeSettings.updatesDirPath = newDir.toString();
            this.application.runtimeSettings.updatesDir = newDir;
            String oldDir = DirBridge.dirUpdates.toString();
            DirBridge.dirUpdates = newDir;
            for (ClientProfile profile : this.application.profilesService.getProfiles()) {
                RuntimeSettings.ProfileSettings settings = this.application.getProfileSettings(profile);
                if (settings.javaPath == null || !settings.javaPath.startsWith(oldDir)) continue;
                settings.javaPath = newDir.toString().concat(settings.javaPath.substring(oldDir.length()));
            }
            this.application.javaService.update();
            updateDirLink.setText(this.application.runtimeSettings.updatesDirPath);
        });
        LookupHelper.lookupIfPossible((Node)this.layout, "#deleteDir").ifPresent(a -> a.setOnAction(e -> this.application.messageManager.showApplyDialog(this.application.getTranslation("runtime.scenes.settings.deletedir.header"), this.application.getTranslation("runtime.scenes.settings.deletedir.description"), () -> {
            LogHelper.debug((String)"Delete dir: %s", (Object[])new Object[]{DirBridge.dirUpdates});
            try {
                IOHelper.deleteDir((Path)DirBridge.dirUpdates, (boolean)false);
            }
            catch (IOException ex) {
                LogHelper.error((Throwable)ex);
                this.application.messageManager.createNotification(this.application.getTranslation("runtime.scenes.settings.deletedir.fail.header"), this.application.getTranslation("runtime.scenes.settings.deletedir.fail.description"));
            }
        }, () -> {}, true)));
        LookupHelper.lookupIfPossible((Node)this.layout, "#back").ifPresent(a -> a.setOnAction(e -> {
            try {
                this.switchToBackScene();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        RuntimeSettings.GlobalSettings settings = this.application.runtimeSettings.globalSettings;
        this.add("PrismVSync", settings.prismVSync, value -> {
            settings.prismVSync = value;
        }, false);
        this.add("DebugAllClients", settings.debugAllClients, value -> {
            settings.debugAllClients = value;
        }, false);
    }
}

